#include <DFPlayerMini_Fast.h>

#if !defined(UBRR1H)
#include <SoftwareSerial.h>
SoftwareSerial mySerial(10, 11); // RX, TX
#endif

DFPlayerMini_Fast myMP3;

#define busy 7
#define Push A0     // Für den Fussschalter Piezo sensor
#define PushKomb A1 // Umgeschaltet Piezo für KombiDrums


int buttonState = 0; // Variable für den aktuellen Zustand des Buttons
int lastButtonState = 0; // Variable für den vorherigen Zustand des Buttons
int track = 1; // Start mit Track 1

const int threshold = 0;

int sensorReading1 = 0; 
int sensorReading2 = 0;


#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#define OLED_RESET    -1
#define SCREEN_WIDTH 128 
#define SCREEN_HEIGHT 32 
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire,OLED_RESET);


#define Clock 2   
#define Data 3    
  
int counter = 0;                    
int currentStateClock;              
int lastStateClock;                 
String currentDir ="";              
unsigned long lastButtonPress = 0;  



void setup() {

  
 
 

  Serial.begin(115200);

 #if !defined(UBRR1H)
  mySerial.begin(9600);
  myMP3.begin(mySerial, true);
#else
  Serial1.begin(9600);
  myMP3.begin(Serial1, true);
#endif
  
  delay(1000);
  
  Serial.println("Setting volume to max");
  myMP3.volume(15);


  
  
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  //define I2C Adress
  display.clearDisplay();




  lastStateClock = digitalRead(Clock);
  counter = 0;
  pinMode(Clock,INPUT_PULLUP);
  pinMode(Data,INPUT_PULLUP);
  pinMode(busy,OUTPUT);
 
}

void loop() {
  
 int Gain =  analogRead(A2)/8;
 int Bpm =  analogRead(A6);
 int BpmTrue = (Bpm/4)-255;
 int threshold = Gain;



sensorReading1 = analogRead(Push);  
sensorReading2 = analogRead(PushKomb); 
  
currentStateClock = digitalRead(Clock);

  
  if (currentStateClock != lastStateClock  && currentStateClock == 1){

   
    if (digitalRead(Data) != currentStateClock) {counter --;
      currentDir ="Counterclockwise";} 
      else {counter ++;
      currentDir ="Clockwise";
    }
display.setTextSize(2);
display.setCursor(10, 0);
display.println(counter);

display.setCursor(40, 0);
display.println("Bpm");

     display.display();
Serial.println(counter);
  }
lastButtonState = buttonState; // Aktuellen Zustand speichern
lastStateClock = currentStateClock;
  
if (counter <= 0) {  
  {counter++;}}                   // Damit nicht über die Grenze im Minusbereich gezählt wird


  
if (sensorReading1 >= threshold){
 myMP3.play(counter);
 delay(Bpm);}                        // Für die Single Percussionen

 
// Es folgen die Kombibefehle für zwei Percussionen im Wechsel  

if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 1)) {
 
 if (track == 1) {myMP3.play(7); track = 2;} 
 else {myMP3.play(9);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 2)) {
 
 if (track == 1) {myMP3.play(2); track = 2;} 
 else {myMP3.play(4);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 3)) {
 
 if (track == 1) {myMP3.play(1); track = 2;} 
 else {myMP3.play(6);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 4)) {
 
 if (track == 1) {myMP3.play(15); track = 2;} 
 else {myMP3.play(11);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 5)) {
 
 if (track == 1) {myMP3.play(10); track = 2;} 
 else {myMP3.play(11);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 6)) {
 
 if (track == 1) {myMP3.play(7); track = 2;} 
 else {myMP3.play(13);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 7)) {
 
 if (track == 1) {myMP3.play(15); track = 2;} 
 else {myMP3.play(1);track = 1;}
 delay(Bpm);}

 if ((sensorReading2 >= threshold && lastButtonState == LOW)&&(counter == 8)) {
 
 if (track == 1) {myMP3.play(10); track = 2;} 
 else {myMP3.play(12);track = 1;}
 delay(Bpm);}




{
    if (counter == 0 ) {
  display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Brush"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); 
  
  }


else if (counter == 1) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Clap"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); 
 } 

      
else if (counter == 2) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Drum");
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 3) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("HiHat1"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 4) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("HiHat2"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 5) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("HipHop"); 
 display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 
     
else if (counter == 6) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Kick"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 7) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Pauke"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 8) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Snare1"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

  else if (counter == 9) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Shaker"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

  else if (counter == 10) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Shell");
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 11) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Snare2"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 12) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Tamburine"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 13) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Tom"); 
 display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 
     
else if (counter == 14) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Drum 1"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 15) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Drum 2"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 

else if (counter == 16) {  
display.clearDisplay(); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(0,17);       
  display.print("Drum 3"); 
  display.setTextSize(2);          
  display.setTextColor(WHITE);     
  display.setCursor(80,0);       
  display.print(BpmTrue); } 




  else if (counter == 17) {  
  {counter--;}}               //Damit nicht über die Grenze hinaus gezählt wird
  






}}
